#!/usr/bin/perl -T
  use strict;
  use re 'taint';
  use Socket;

# Usage:
#   p0f -i bge0 -l 'dst host 193.2.4.66 and tcp dst port 25' 2>&1 | \
#     p0f-analyzer.pl

  my($retention_time) = 10*60;
  my($port) = 2345;
  socket(S, PF_INET, SOCK_DGRAM, getprotobyname('udp')) or die "socket: $!";
  bind(S, sockaddr_in($port,INADDR_ANY)) or die "bind: $!";
  my($fn_sock) = fileno(S); my($fn_stdin) = fileno(STDIN);
  my($rin,$rout); $rin = '';
  vec($rin,$fn_sock,1) = 1; vec($rin,$fn_stdin,1) = 1;
  my(%src); my($cnt_since_cleanup) = 0;
  binmode(STDIN)  or die "Can't set STDIN binmode: $!";
  for (;;) {
    my($nfound,$timeleft) = select($rout=$rin, undef, undef, undef);
    my($now) = time;
    if (vec($rout,$fn_sock,1)) {
      my($inbuf);  my($hispaddr) = recv(S,$inbuf,64,0);
      defined $hispaddr or die "recv: $!";
      my($port,$hisiaddr) = sockaddr_in($hispaddr);
      if ($inbuf =~ /^(\d+\.\d+\.\d+\.\d+) ([^ ]*)$/) {
        my($src_ip,$nonce) = ($1,$2); my($resp) = ''; my($timestamp);
        if (exists($src{$src_ip})) {
          for my $e (@{$src{$src_ip}}) {
            $timestamp = $e->{t};
            if ($resp eq '') { $resp = $e->{d} }
            elsif ($e->{d} eq $resp) {}
            else {  # keep the longest common string head
              my($j);  my($resp_l) = length($resp);
              for ($j=0; $j<$resp_l; $j++)
                { last  if substr($e->{d},$j,1) ne substr($resp,$j,1) }
              if ($j < $resp_l) {
#               printf("TRUNCATED to %d: %s %s => /%s/\n",
#                      $j, $resp, $e->{d}, substr($resp,0,$j));
                $resp = substr($resp,0,$j);
              }
            }
            last;
          }
        }
        $resp = $src_ip.' '.$nonce.' '.$resp;
#       printf("SEND: %s\n", $resp);
        defined(send(S, $resp."\015\012", 0, $hispaddr)) or die "send: $!";
      }
    }
    if (vec($rout,$fn_stdin,1)) {
      my($line);  my($nbytes) = sysread(STDIN,$line,1024);
      defined $nbytes or die "Read: $!";
      chomp($line); $cnt_since_cleanup++;
      $line =~ /^(\d+\.\d+\.\d+\.\d+):(\d+)[ -]*(.*)
                  \ ->\ (\d+\.\d+\.\d+\.\d+):(\d+)\s*(.*)$/x or next;
      my($src_ip,$src_port,$src_t,$dst_ip,$dst_port,$src_d) =
        ($1,$2,$3,$4,$5,$6);
      my($descr) = "$src_t, $src_d";
      if (!exists($src{$src_ip})) {
#       printf("first: %s %s %.70s\n", $src_ip, $src_port, $descr);
        $src{$src_ip} = [ { t=>$now, p=>$src_port, c=>1, d=>$descr } ]
      } else {
        my($found) = 0;
        for my $e (@{$src{$src_ip}}) {
          if ($e->{d} eq $descr) {
            $e->{c}++; $e->{p} = '*'; $e->{t} = $now, $found = 1;
#           printf("deja-vu: %s %d, cnt=%d %.70s\n",
#                   $src_ip,$src_port,$e->{c},$descr);
            last;
          }
        }
        if (!$found) {
          push(@{$src{$src_ip}}, { p=>$src_port, c=>1, d=>$descr });
#         printf("new: %s %d %.70s\n", $src_ip,$src_port,$descr);
        }
      }
      if ($cnt_since_cleanup > 50) {
        for my $ip (keys %src) {
          my(@kept) = grep { $_->{t} + $retention_time >= $now } @{$src{$ip}};
          if (!@kept) {
#           printf("EXPIRED: %s, age = %d s\n", $ip, $now - $src{$ip}[0]{t});
            delete $src{$ip};
          } elsif (@kept != @{$src{$ip}}) {
#           printf("SHRUNK: %s\n", $ip);
            @{$src{$ip}} = @kept;
          }
        }
        $cnt_since_cleanup = 0;
      }
    }
  }
